var XWiki = (function (XWiki) {
// Start XWiki augmentation.
Object.extend(XWiki, {
  userprofile : {
    init : function(container) {
      this.crtCategory = '';
      this.tabsContainer = (container || $('body')).down('#user-vertical-menu');
      if (!this.tabsContainer) {
        return;
      }
      this.tabsContainer.select('.category-tab').each(function (tabElement) {
        tabElement.observe('click', function(event) {
          Event.stop(event);
          this.switchTab(tabElement.id, true);
        }.bindAsEventListener(this));
      }.bind(this));
      this.tabsContainer.select('.category-tab.current').each(function (activeTab) {
        this.updateCategoryFields(activeTab.id);
        document.fire('xwiki:profile:switchedCategory', {'category' : activeTab.id});
        document.fire('xwiki:dom:refresh');
      }.bind(this));
      this.handleCancelAction();

      // History navigation through our pushed states.
      window.addEventListener('popstate', function(event) {
        if (event.state && event.state.category) {
          this.switchTab('vertical-menu-' + event.state.category);
        }
      }.bindAsEventListener(this));
      // Store the initial history state so we can go back.
      history.replaceState({
        category: window.location.search.toQueryParams().category || 'profile'
      }, document.title, document.location.href);
    },

    switchTab : function(tab, pushHistory) {
      var tabName = tab.substring(14); // 14 = len('vertical-menu-')
      $("user-page-content").select("div.user-page-pane").each(function(pane){
        pane.addClassName('hidden');
      });
      $(tabName + 'Pane').removeClassName('hidden');
      $("user-vertical-menu").select("span.category-tab").each(function(tab){
        tab.removeClassName('current');
      });
      $(tab).addClassName('current');
      this.updateCategoryFields(tab);
      if (pushHistory) {
        this.updateURL(tabName);
      }
      document.fire('xwiki:profile:switchedCategory', {'category' : tab});
      document.fire('xwiki:dom:refresh');
    },

    updateCategoryFields : function (category) {
      category = category.substring(14); // 14 = len('vertical-menu-')
      this.crtCategory = category;
      this.updateField('xredirect', XWiki.currentDocument.getURL('view', 'category=' + category));
      this.updateField('xcontinue', XWiki.currentDocument.getURL('edit', 'editor=inline&category=' + category));
      this.updateField('category', category);
    },

    updateURL : function (category) {
      if (history.pushState) {
        var params = window.location.search.toQueryParams();
        params.category = category;
        var newQueryString = Object.toQueryString(params);

        var newURL = window.location.protocol + '//' + window.location.host + window.location.pathname + '?' + newQueryString;
        window.history.pushState({category : category}, '', newURL);
      }
    },

    updateField : function (fieldName, value) {
      var element = $$('input[name=' + fieldName + ']');
      if (element && element.size() > 0) {
        element[0].value = value;
      }
    },

    handleCancelAction : function() {
      var elements = $$('form .buttons input[type=submit][name=action_cancel]');
      if (elements && elements.size() > 0) {
        var button = elements[0];
        Event.stopObserving(button, 'click');
        button.observe('click', function(event){
          event.stop();
          window.location = XWiki.currentDocument.getURL('view', 'category=' + this.crtCategory)
        }.bindAsEventListener(this));
      }
    }
  }
});

var init = function(event) {
  ((event && event.memo.elements) || [$('body')]).each(function(element) {
    XWiki.userprofile.init(element);
  });
  return true;
};
(XWiki.domIsLoaded && init()) || document.observe('xwiki:dom:loaded', init);
document.observe('xwiki:dom:updated', init);
// End XWiki augmentation.
return XWiki;
}(XWiki || {}));
